###########################################################
# Consumo de datos vía API
# Consumo usando herramientas básicas
###########################################################

###########################################################
# importación directa de json
###########################################################

library("RJSONIO") 

mi.url  <- 'http://maps.google.com/maps/api/geocode/json?sensor=false&address=Zaragoza' 
mi.json <- paste(readLines(mi.url), collapse=" ")
mi.data <- fromJSON(mi.json)

# extracción de los componentes de interés

data.json <- unlist(data.json)
lat <- data.json["results.geometry.location.lat"]
lng <- data.json["results.geometry.location.lng"]
gcodes <- c(lat, lng)
names(gcodes) <- c("Lat", "Lng")

gcodes


#### otro ejemplo:  http://www.datanalytics.com/blog/2012/03/14/%C2%A1mano-que-mapa/
  
###########################################################
# importación directa de json
###########################################################

library(RCurl)

bearer <- "KGVKOr8xyukLXQ3e3YHMAtkfyB8a"

termino <- "casas"

mdi.url <- paste("http://store.apicultur.com/api/lematiza-clasico/1.0.0/", termino, sep = "" )
OAuthString <- paste("Bearer", bearer)

httpHeader <- c("Authorization" = OAuthString, 
                "Accept" = "application/json", 
                "Content-Type" = "application/json")

tg <- basicTextGatherer()
    
httpResponse <- curlPerform(url = mdi.url, httpheader = httpHeader, writefunction = tg$update)
      
tmp <- tg$value()  
tmp <- fromJSON(iconv(tmp, to = "LATIN1"))$lemas
tmp <- as.data.frame(do.call(rbind, tmp), stringsAsFactors = FALSE)


### API de sentimiento

tuit <- "Julián es un cabrón"

mdi.url <- paste(
  "https://store.apicultur.com/api/stmtlk/1.0.0/valoracion/tweet/10/",
  URLencode(tuit), sep = "" )

tg <- basicTextGatherer()

httpResponse <- curlPerform(url = mdi.url, httpheader = httpHeader, writefunction = tg$update)

tmp <- tg$value()  
  


