###########################################################
# Consumo de datos vía API
# Unas cuantas APIs predefinidas
###########################################################

# En esta sección examinaremos un conjunto de paquetes de R
# que permiten consumir datos a través de APIs.

###########################################################
### Prensa: la API de The Guardian
###
###   API info:     http://www.guardian.co.uk/open-platform
###   API examples: http://www.guardian.co.uk/open-platform/apps

#install.packages("GuardianR")

library(GuardianR)
res <- get_guardian(keywords="Spain", from.date="2013-05-23", to.date="2013-05-30")

sort(table(res$sectionId))

subset(res, sectionId == "science")

?get_guardian

###########################################################
### Política
###
###   https://github.com/SChamberlain/govdat

#install.packages("govdat")

library(govdat)
res <- nyt_cg_rollcallvote(112, 'house', 1, 00235)

# nota: necesita un API key (registrarse en el NYT, etc.)

###########################################################
### Ciencia

# http://ropensci.org/
# http://ropensci.org/packages/index.html

#install.packages("rgbif")

# library(rgbif)
# 
# sname <- 'Aratinga holochlore'  # Wrong name
# # Get records of sname (which is wrong )
# out2 <- occurrencelist(sciname = sname, coordinatestatus = TRUE, latlongdf = TRUE )
# out2
# 
# sname <- 'Danaus plexippus' # Monarch butterfly
# out3 <- occurrencelist(sciname = sname, coordinatestatus = TRUE, latlongdf = TRUE, format = 'brief' )
# out3

###########################################################
### Economía y finanzas
### WDI (World Bank Data API)

# https://github.com/vincentarelbundock/WDI

# install.packages("WDI")

library(WDI)

res <- WDI(country = "ES", indicator = "NY.GNS.ICTR.GN.ZS", 
           start = 2002, end = 2005, 
           extra = FALSE, cache = NULL)

### Bolsa

http://www.datanalytics.com/blog/2013/02/27/que-ha-pasado-en-el-ibex-durante-el-ultimo-mes/

###########################################################
### Geolocalización

library(ggmap)
res <- geocode("Madrid, España")

res.botin <- geocode("Restaurante Botín, Madrid")
res.botin

###########################################################
### Mapas

# http://www.datanalytics.com/blog/2013/04/08/mapa-de-los-terremotos-en-la-peninsula-iberica/

library(ggmap)

url <- "http://comcat.cr.usgs.gov/earthquakes/feed/search.php?maxEventLatitude=45&minEventLatitude=35&minEventLongitude=-10&maxEventLongitude=5&minEventTime=953683200000&maxEventTime=1364688000000&minEventMagnitude=-1.0&maxEventMagnitude=10&minEventDepth=0.0&maxEventDepth=800.0&format=csv"
terremotos <- read.csv(url)

# obtengo un mapa
pen.iber <- get_map( location = c(-9.5, 36, 3.5, 44),
                     color = "color",
                     maptype = "roadmap")

# le añado puntos
ggmap(pen.iber) +
  geom_point(aes(x = Longitude, y = Latitude,
                 size = Magnitude),
             data = terremotos, colour = 'red',
             alpha = 0.2)